/***********************************************************************\
*                             pentominoes.d                             *
*                                                                       *
*                                 Pentis                                *
*                                                                       *
*                              Version 0.01                             *
*                                                                       *
*                               The pieces                              *
>***********************************************************************<
* Copyright (C) 2005 Stewart Gordon.                                    *
*                                                                       *
* This software is provided 'as-is', without any express or implied     *
* warranty.  In no event will the author be held liable for any damages *
* arising from the use of this software.                                *
*                                                                       *
* Permission is granted to anyone to use this software for any purpose, *
* to alter it and redistribute it freely in source or binary form and   *
* to create and distribute derivative works, subject to the following   *
* restrictions:                                                         *
*                                                                       *
* - The origin of this software must not be misrepresented; you must    *
*   not claim that you wrote the original software.                     *
* - Altered versions must be plainly marked as such, and must not be    *
*   misrepresented as being the original software.                      *
* - Derivative works must retain the original author's credit in the    *
*   documentation.                                                      *
* - This notice may not be removed or altered from any source           *
*   distribution.                                                       *
*                                                                       *
* For updates and information related to this product, visit            *
* http://www.stewartsplace.org.uk/software/pentis/.                     *
* Email me with comments/suggestions/bug reports: smjg@iname.com        *
\***********************************************************************/
module smjg.apps.pentis.pentominoes;

enum PENT {
	CLEAR,
	// symmetrical pieces
	O, T, U, V, W, X,
	// chiral pieces
	P1, P2, Q1, Q2, R1, R2, S1, S2, Y1, Y2, Z1, Z2//,
	//LINE
}

alias bit[5][5] PentShape;

struct PentType {
	PentShape[] shape;
	int yInit = -1;
}

PentType[PENT.max + 1] pieces = [
	PENT.O: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 1,1,1,1,1 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ]]], -2},

	PENT.P1: {
		[[[ 0,0,0,0,0 ],
		  [ 1,1,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.P2: {
		[[[ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 1,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.Q1: {
		[[[ 0,0,0,0,0 ],
		  [ 1,1,1,1,0 ],
		  [ 1,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,0,1,0 ],
		  [ 1,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.Q2: {
		[[[ 0,0,0,0,0 ],
		  [ 1,1,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 1,0,0,0,0 ],
		  [ 1,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.R1: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.R2: {
		[[[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.S1: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 1,1,1,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 1,1,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.S2: {
		[[[ 0,0,0,0,0 ],
		  [ 1,1,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 1,1,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.T: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 1,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,1,1 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.U: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,1,0,1,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,1,0,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,0,0 ]]], -2},

	PENT.V: {
		[[[ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.W: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.X: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.Y1: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,1,1,1,1 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 1,1,1,1,0 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]]], -2},

	PENT.Y2: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ],
		  [ 1,1,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,1,1 ],
		  [ 0,0,0,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,0,0 ]]], -2},

	PENT.Z1: {
		[[[ 0,0,0,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,0,0,0,0 ]]]},

	PENT.Z2: {
		[[[ 0,0,0,0,0 ],
		  [ 0,0,1,1,0 ],
		  [ 0,0,1,0,0 ],
		  [ 0,1,1,0,0 ],
		  [ 0,0,0,0,0 ]],

		 [[ 0,0,0,0,0 ],
		  [ 0,1,0,0,0 ],
		  [ 0,1,1,1,0 ],
		  [ 0,0,0,1,0 ],
		  [ 0,0,0,0,0 ]]]}
];
